# Windows10
The Orbbec SDK is compatible with the standard UVC protocol, and the supported hardware devices comply with the standard UVC specifications, so no additional drivers are required. <br />
Orbbec SDK version 1.4.3 and above supports access to old openni devices (such as Dabai, Dabai DCW, Dabai DW, Astra Mini, Astra mini Pro, Gemini E, Gemini E Lite, etc.), these devices need to install private drivers (such as SensorDriver_V4.3.0.xx.exe).
## 1. Verify device status

- Connect the device to the host
- Navigate to "Control Panel" -> "Device Manager"
- Browse to find the Orbbec device, as shown in the figure below, the device is successfully connected. (Different devices may have different channel numbers.

![1](.\EnvironmentConfigurationImage\1.png)
## 2. Configure OpenCV (Examples dependency)
Data rendering relies on the third-party library OpenCV. Here we take OpenCV 4.3.0 as an example to demonstrate the installation configuration.

* Execute the OpenCV installation file, select the directory where opencv is to be installed, and click extract to execute the installation.

![2](EnvironmentConfigurationImage/orbbec_opencv_001.png)

* Add the path of OpenCV in the environment variables of the system, enter OpenCV_DIR for the variable name, pay attention to the capitalization of the letters, and the variable value is the path to the build folder of the OpenCV installation directory.

![3](EnvironmentConfigurationImage/orbbec_opencv_002.png)

![4](EnvironmentConfigurationImage/orbbec_opencv_003.png)

## 3. metadata Timestamp Registration

Now due to the Windows system mechanism, for UVC protocol devices, if you need to obtain metadata information such as timestamps, you need to first register in the registry. Using obsensor_metadata_win10.md document guide to complete the registry registration.

![5](EnvironmentConfigurationImage/orbbec_metadata.png)

## 4. Generate your first application
Software dependency: VisualStudio2019, cmake 3.10 and above.
* Download Orbbec SDK software package. Take version 1.5.7 as an example to explain how Windows compiles.

* Open Cmake and set the "Examples" folder as the code path, and the "build" folder under "Examples" as the path to generate the binary file, as shown in the figure below. If there is no build under Examples, you need to create a new folder.


![6](EnvironmentConfigurationImage/orbbec_sample_005.png)

* Click "Configure" and select the corresponding Visual Studio version and platform version, then click "Finish", as shown below:

![7](EnvironmentConfigurationImage/orbbec_sample_006.png)

* Click "Generate", as shown below:

![8](EnvironmentConfigurationImage/orbbec_sample_007.png)

* The Sample project can be opened in the following two ways.

Method 1: With cmake, click the "Open Project" button to open the Visual Studio project.

![9](EnvironmentConfigurationImage/orbbec_sample_008.png)

Method 2: In the folder, directly start the Visual Studio project in Examples/build, as shown in the figure below.

![10](EnvironmentConfigurationImage/orbbec_sample_009.png)

* Open the Examples project interface as shown below:

![11](EnvironmentConfigurationImage/orbbec_sample_010.png)

* Select the project you want to run, right click and "set as startup project", select release and 64-bit version at the run option.


* Connect the device to the host

* Copy the dll files from the bin directory of the Examples folder to the build folder where the generated executables located at.
![13](EnvironmentConfigurationImage/orbbec_sample_013.png)

*  run the HelloOrbbec project

![14](EnvironmentConfigurationImage/orbbec_sample_014.png)

# Android
## 1. Verify device status
* Prepare a set of P1 development board (A311D), the environment is Android 9.
* Prepare ADB tools and configure environment variables locally on the PC.
*  Prepare USB cable for the connection of the A311D and the PC. At the same time, A311D system can be accessed for debugging through ADB tool (identify A311D as drive-free), and prepare USB 3.0 Type-C cable to connect A311D and Astra+ camera.

![15](.\EnvironmentConfigurationImage\15.png)

![16](.\EnvironmentConfigurationImage\16.png)

* Take ASTRA+ as an example to determine whether A311D identifies as a camera normally.

Judging by the lsusb command:<br />VID: 2bc5 PID: 0532 (color camera)<br />VID: 2bc5 PID: 0636 (depth camera) <br />

![17](.\EnvironmentConfigurationImage\17.png)

* If the system can recognize the camera normally, the device PID will be enumerated on the USB bus (as shown in the picture above), indicating that the A311D has recognized the camera and can do subsequent operations.

## 2. AAR file import
We have encapsulated the corresponding file into an aar file (OrbbecSDK_v1.0.0_release.aar), you can directly import it into the project.
*  Put "obsensor_xxxx_release.aar" in the libs directory under module;
*  Add local dependencies in the dependencies of the module's build.gradle;
* Click File --> Sync Project with Gradle Files of AS and wait for the update to complete.

![18](.\EnvironmentConfigurationImage\18.png)

* Configure AndroidManifest.xml permissions, the SDK needs to monitor the permissions of USB devices and cameras, apply statically in AndroidManifest.xml, and dynamically apply when Java/kotlin is running;
* In our corresponding Java file, "import com.orbbec.obsensor.*", add the corresponding code, as shown below:

![19](.\EnvironmentConfigurationImage\19.png)

If the corresponding SDK version information is printed out normally, the SDK integration is successful.

## 3. Example project import
In addition to the aar file, we also provide an example project, you can directly open the corresponding Android project for viewing and development.
## 4. Obfuscated configuration
If the project has Proguard configuration, then it is necessary to keep the Orbbec SDK Jave class.

``` bash
-keep class com.orbbec.obsensor.**
-dontwarn com.orbbec.obsensor.**
-keepclassmembers class com.orbbec.obsensor.** { *; }
-keepclasseswithmembernames,includedescriptorclasses class * {
    native <methods>;
}
```

# Linux
## 1. System environment configuration
* Install libudev library: 
``` bash
sudo apt install libudev-dev
```

* Install libusb library: 
``` bash
sudo apt install libusb-dev
```

## 2. USB access rights configuration
By default, direct access to USB devices in Linux systems requires root privileges, which can be resolved through the rules configuration file. After the files released by Orbbec SDK are decompressed, there will be a "99-obsensor-libusb.rules" configuration file and "install.sh" installation script in the Script directory.

![20](EnvironmentConfigurationImage/orbbec_sample_linux_001.png)
Run the "install.sh" script through the sudo command to complete the rules Installation of configuration files.
``` bash
sudo chmod +x ./install.sh
sudo ./install.sh
 ```

## 3. Increasing the USBFS buffer size (Optional)

By default, the USBFS buffer size is 16 MB. This value is insufficient for high-resolution images or multiple streams and multiple devices usage. User can increase the buffer size to 128 MB.

### Check the USBFS buffer size:

```bash
cat /sys/module/usbcore/parameters/usbfs_memory_mb
```

### Increase the USBFS buffer size until the next reboot (here: example value 128)

``` bash
sudo sh -c 'echo 128 > /sys/module/usbcore/parameters/usbfs_memory_mb'
```

### Increase the USBFS buffer size permanently

To increase the buffer size permanently, add the kernel parameter usbcore.usbfs_memory_mb=128 to the bootloader configuration. How to do this depends on the bootloader on your system.

For GRUB2 (most common):

  1. Open /etc/default/grub. Replace: `GRUB_CMDLINE_LINUX_DEFAULT="quiet splash"` (or other contents within the quotation marks depending on your system) with: `GRUB_CMDLINE_LINUX_DEFAULT="quiet splash usbcore.usbfs_memory_mb=128"`

  2. Update grub

     ``` bash
      sudo update-grub
     ```

  3. reboot your system

Other bootloaders: configure additional kernel parameters of other bootloaders, please see the manual of your bootloader.

## 4. Verify device status
* Environment preparation: ubuntu18.04 x64 desktop

* Take Astra+ as an example, use USB 3.0 Type-C data cable to connect with PC.

* Use the lsusb command to check if the PC system correctly recognizes the camera.

![21](EnvironmentConfigurationImage/orbbec_sample_linux_002.png)

* Judge whether the camera is recognized normally by PID&VID
VID: 2bc5 PID: 0536 (color camera)
VID: 2bc5 PID: 0636 (depth camera)


## 5、Linux Sample compile
Create a build directory in the Examples directory, as follows:
![22](EnvironmentConfigurationImage/orbbec_sample_linux_003.png)
``` bash
cd build 
cmake .. 
make
```